#define COMM_BAUD														12800
																						

//Comm Thread State Machine States
#define STATE_IDLE													0
#define STATE_OPEN_PORT                     1
#define STATE_PROCESS_REQUEST								2
#define STATE_SEND_REQUEST									3
#define STATE_WAIT_FOR_RESPONSE							4
#define STATE_RETRY													5
#define STATE_CHECK_RESPONSE								6
#define STATE_PROCESS_RESPONSE							7


// Comm window messages to user interface code
#define COMM_RESPONSE_RECEIVED						  WM_APP+1
#define COMM_RESPONSE_FAILED							  WM_APP+2
#define UPDATE_LED                          WM_APP+3


#define TURN_LED_ON                         1
#define TURN_LED_OFF                        2

//Comm Thread: Local Error Codes
#define COMM_INVALID_COM_PORT               0x8001
#define COMM_INVALID_COM_PORT_TEXT          "No COM port selected!"
#define COMM_OPEN_FAILED									  0x8002
#define COMM_OPEN_FAILED_TEXT               "Could not open COM Port!"
#define COMM_CONFIG_FAILED								  0x8003
#define COMM_CONFIG_FAILED_TEXT             "Could not configure COM Port!"
#define COMM_WRITE_FAILED									  0x8004
#define COMM_WRITE_FAILED_TEXT              "Failed while writing to COM Port!"
#define COMM_SET_TIMEOUT_FAILED             0x8005
#define COMM_SET_TIMEOUT_FAILED_TEXT        "Could not set Timeout for COM Port!"



//Comm protocol errors 
#define COMM_LOCAL_TITLE									  "Local Error:"
#define COMM_PVCC_TITLE									    "PVCC Error:"
#define COMM_INVALID_REQUEST							  0x8010
#define COMM_INVALID_REQUEST_ERROR_TEXT		  "Unknown Command Requested!"
#define COMM_RECEIVED_NO_VALID_RESPONSE		  0x8011
#define COMM_RECEIVED_NO_VALID_RESPONSE_TEXT "No valid response was received after 3 tries!"
#define COMM_RECEIVED_BAD_CRC							  0x8012
#define COMM_RECEIVED_BAD_CRC_TEXT				  "Response message had invalid CRC checksum"
#define COMM_PVCC_REPORTED_BAD_CRC          0x8013
#define COMM_PVCC_REPORTED_BAD_CRC_TEXT     "PVCC unit received an invalid message from host PC"
#define COMM_RECEIVED_INVALID_RESPONSE      0x8014
#define COMM_RECEIVED_INVALID_RESPONSE_TEXT "Received an invalid response from PVCC"
#define COMM_UNKNOWN_ERROR_TEXT             "An Unknown Error was reported from the PVCC unit"

//Comm protocol parameters
#define COMM_RESPONSE_DELAY 			 				  1000 			// 1 second
#define RETRY_DELAY                         250       // Delay before retry, this allow server to time to get to state 0
#define COMM_MAX_RETRIES					 				  3




// These errors will be send back to the client to indicate a failure occured while processing the clients request
//#define COMM_ERROR_TITLE									  "Remote Error:"
#define COMM_NO_ERROR					 						  0x80



#define CMD_GET_CONFIG                      0xA1
#define CMD_GET_CONFIG_REQ_LEN              1
#define CMD_GET_CONFIG_RSP_LEN              sizeof(PVCC_CONFIG_DATA)

#define CMD_SEND_CONFIG                     0xAF
#define CMD_SEND_CONFIG_REQ_LEN             sizeof(REQUEST_BUFFER)
#define CMD_SEND_CONFIG_RSP_LEN             2

#define RSP_ID_BYTE                         0xFA
#define RSP_GOOD_CRC                        0x11
#define RSP_BAD_CRC                         0xFF


#define PVCC_CONFIG_DATA_VERSION            2
#define PVCC_SAMPLE_FREQ                    250         //  1 / 4ms

#pragma pack (1)

typedef struct                  // used to send to the PVCC unit
{
  BYTE Instruction;             // Command being requested from Client
  WORD CRC16;                   // CRC16 for this packet calculated
  BYTE ConfigVersion; 
  BYTE UpdatePeriod;            // Number of 8ms periods to delay between data readings
  WORD MaxChargeVolts;          // xx.x Stop charging when voltage is at or above this value
  WORD MinChargeVolts;          // xx.x Start charging when voltage falls below this value
  WORD DisconnectVolts;         // xx.x Low Voltage Disconnect point
  WORD ReconnectVolts;          // xx.x Reconnect voltage after LVD has been reached
  WORD MaxChargeTemp;           // xx.x Max battery temperature
  BYTE MinOnLightLevel;         // Minimum light level for loads to be on
  BYTE MaxOffLightLevel;        // Maximum light level that loads can still be off at
  BYTE EnableLVD;               // Boolean, if set, Enable LVD feature
  BYTE EnableLoadControl;       // Boolean, if set, Night OFF / Day ON, automatic load control
  BYTE EnableCharging;          // Boolean, if set, enable charging
  BYTE UseTempSensor;           // Boolean, if set, monitor temperature while charging
  BYTE EnableOSD;               // Boolean, if set, allow the OSD feature.
  BYTE DisplayAtBottom;         // Boolean, if set, show OSD at top of screen, else show at bottom
  BYTE EnableCallsign;          // Boolean, if set, display callsign briefly every 10 min.
  CHAR CallsignText[10];        // String 9 chars, plus null            

} REQUEST_BUFFER;

typedef struct 
{
  WORD CRC16;                   // CRC16 for this packet calculated
  BYTE ConfigVersion; 
  BYTE UpdatePeriod;            // Number of 8ms periods to delay between data readings
  WORD MaxChargeVolts;          // xx.x Stop charging when voltage is at or above this value
  WORD MinChargeVolts;          // xx.x Start charging when voltage falls below this value
  WORD DisconnectVolts;         // xx.x Low Voltage Disconnect point
  WORD ReconnectVolts;          // xx.x Reconnect voltage after LVD has been reached
  WORD MaxChargeTemp;           // xx.x Max battery temperature
  BYTE MinOnLightLevel;         // Minimum light level for loads to be on
  BYTE MaxOffLightLevel;        // Maximum light level that loads can still be off at
  BYTE EnableLVD;               // Boolean, if set, Enable LVD feature
  BYTE EnableLoadControl;       // Boolean, if set, Night OFF / Day ON, automatic load control
  BYTE EnableCharging;          // Boolean, if set, enable charging
  BYTE UseTempSensor;           // Boolean, if set, monitor temperature while charging
  BYTE EnableOSD;               // Boolean, if set, allow the OSD feature.
  BYTE DisplayAtBottom;         // Boolean, if set, show OSD at top of screen, else show at bottom
  BYTE EnableCallsign;          // Boolean, if set, display callsign briefly every 10 min.
  CHAR CallsignText[10];        // String 9 chars, plus null            

} PVCC_CONFIG_DATA;

const unsigned int CRCTable[] = {
  0x0000, 0xC0C1, 0xC181, 0x0140, 0xC301, 0x03C0, 0x0280, 0xC241,
  0xC601, 0x06C0, 0x0780, 0xC741, 0x0500, 0xC5C1, 0xC481, 0x0440,
  0xCC01, 0x0CC0, 0x0D80, 0xCD41, 0x0F00, 0xCFC1, 0xCE81, 0x0E40,
  0x0A00, 0xCAC1, 0xCB81, 0x0B40, 0xC901, 0x09C0, 0x0880, 0xC841,
  0xD801, 0x18C0, 0x1980, 0xD941, 0x1B00, 0xDBC1, 0xDA81, 0x1A40,
  0x1E00, 0xDEC1, 0xDF81, 0x1F40, 0xDD01, 0x1DC0, 0x1C80, 0xDC41,
  0x1400, 0xD4C1, 0xD581, 0x1540, 0xD701, 0x17C0, 0x1680, 0xD641,
  0xD201, 0x12C0, 0x1380, 0xD341, 0x1100, 0xD1C1, 0xD081, 0x1040,
  0xF001, 0x30C0, 0x3180, 0xF141, 0x3300, 0xF3C1, 0xF281, 0x3240,
  0x3600, 0xF6C1, 0xF781, 0x3740, 0xF501, 0x35C0, 0x3480, 0xF441,
  0x3C00, 0xFCC1, 0xFD81, 0x3D40, 0xFF01, 0x3FC0, 0x3E80, 0xFE41,
  0xFA01, 0x3AC0, 0x3B80, 0xFB41, 0x3900, 0xF9C1, 0xF881, 0x3840,
  0x2800, 0xE8C1, 0xE981, 0x2940, 0xEB01, 0x2BC0, 0x2A80, 0xEA41,
  0xEE01, 0x2EC0, 0x2F80, 0xEF41, 0x2D00, 0xEDC1, 0xEC81, 0x2C40,
  0xE401, 0x24C0, 0x2580, 0xE541, 0x2700, 0xE7C1, 0xE681, 0x2640,
  0x2200, 0xE2C1, 0xE381, 0x2340, 0xE101, 0x21C0, 0x2080, 0xE041,
  0xA001, 0x60C0, 0x6180, 0xA141, 0x6300, 0xA3C1, 0xA281, 0x6240,
  0x6600, 0xA6C1, 0xA781, 0x6740, 0xA501, 0x65C0, 0x6480, 0xA441,
  0x6C00, 0xACC1, 0xAD81, 0x6D40, 0xAF01, 0x6FC0, 0x6E80, 0xAE41,
  0xAA01, 0x6AC0, 0x6B80, 0xAB41, 0x6900, 0xA9C1, 0xA881, 0x6840,
  0x7800, 0xB8C1, 0xB981, 0x7940, 0xBB01, 0x7BC0, 0x7A80, 0xBA41,
  0xBE01, 0x7EC0, 0x7F80, 0xBF41, 0x7D00, 0xBDC1, 0xBC81, 0x7C40,
  0xB401, 0x74C0, 0x7580, 0xB541, 0x7700, 0xB7C1, 0xB681, 0x7640,
  0x7200, 0xB2C1, 0xB381, 0x7340, 0xB101, 0x71C0, 0x7080, 0xB041,
  0x5000, 0x90C1, 0x9181, 0x5140, 0x9301, 0x53C0, 0x5280, 0x9241,
  0x9601, 0x56C0, 0x5780, 0x9741, 0x5500, 0x95C1, 0x9481, 0x5440,
  0x9C01, 0x5CC0, 0x5D80, 0x9D41, 0x5F00, 0x9FC1, 0x9E81, 0x5E40,
  0x5A00, 0x9AC1, 0x9B81, 0x5B40, 0x9901, 0x59C0, 0x5880, 0x9841,
  0x8801, 0x48C0, 0x4980, 0x8941, 0x4B00, 0x8BC1, 0x8A81, 0x4A40,
  0x4E00, 0x8EC1, 0x8F81, 0x4F40, 0x8D01, 0x4DC0, 0x4C80, 0x8C41,
  0x4400, 0x84C1, 0x8581, 0x4540, 0x8701, 0x47C0, 0x4680, 0x8641,
  0x8201, 0x42C0, 0x4380, 0x8341, 0x4100, 0x81C1, 0x8081, 0x4040
};

